require( "scripts/style.lua" );

function StartGame(showComic)
	if (SetupGame()) then
		restaurantName = GetCurrentRestaurantName();
		comicName = GetRestaurantFolder(restaurantName).."/comics/intro.swf";
		if (FileExists(comicName) and showComic) then
			incrementedComicName = GetStrSetting("incrementrestaurant_mapscreenmovie", "");
			comicName = ConvertSWFPath(comicName);
			
			SetDefaultStyle(ComicStyle);
			ActivateMovieClock(true);
			PlayMovieMusic(GetRestaurantMovieMusic(GetCurrentRestaurantName(), "intro"));
			DisplaySplash(comicName, "",1);
			ActivateMovieClock(false);
			SetDefaultStyle(DefaultStyle);
			SetBoolSetting(restaurantName .. "_intro_movie", true);
			SaveSettings();
		end
			
		PreloadCustomers();
		ReleaseMapAssets();
		PopModal("scripts/chooserestaurant.lua");
		DoModal("scripts/game.lua");
	else
		DisplayDialog{
			'scripts/ok.lua', 
			body ='leveltrialexpired',
			title = ''};
	end
end

function ClickOnDiner()
	MetricEvent(eMyDinerMapVisits);
	if (Login(false, false)) then
		if (GetBoolSetting("firstmydiner", true)) then
			result = DisplayDialog { 
				"scripts/yesno.lua", 
				body ="map_first_mydiner",
				title = "" 
			};
			if (result=='yes') then
				SelectMyDiner();
			end
		else
			SelectMyDiner();
		end
	end
end

GameModeFont = {
  standardFont,
  35,
  BorderColor
};

InfoFont = {
  standardFont,
  18,
  BorderColor
};

BestScoreFont = {
  standardFont,
  20,
  BlackColor;
};

LevelNumFont = {
  standardFont,
  12,
  BlackColor;
};

SelectRestaurantFont = {
  standardFont,
  28,
  WhiteColor;
};

MyDinerFont = {
  standardFont,
  16,
  BlackColor;
};

MyDinerRolloverFont = {
  standardFont,
  16,
  BlackColor;
};

RestaurantRolloverFont = {
  standardFont,
  24,
  BlackColor;
};

MapArrowFont = {
  standardFont,
  16,
  BlackColor;
};

LevelButtonGraphics = {
	"map/dot_off",
	"map/dot_on",
	"map/dot_off",
	"map/dot_on"
};

ExpertButtonGraphics = {
	"map/expert_off",
	"map/expert_on",
	"map/expert_off",
	"map/expert_on"
};

PlayButtonGraphics = {
	"map/map_ui_button_a",
	"map/map_ui_button_b",
	"map/map_ui_button_c"
};

NextMapGraphics = {
	"buttons/left_arrow_a",
	"buttons/left_arrow_b",
	"buttons/left_arrow_c"
};

NextMapUpGraphics = {
	"buttons/arrowup_a",
	"buttons/arrowup_b",
	"buttons/arrowup_c",
	"buttons/arrowup_d"
}

MapForSaleJustBuyGraphics = {
	"buttons/justbuynow",
	"buttons/justbuynow_highlight",
	"buttons/justbuynow_highlight"
};

MapForSaleGraphics = {
	"buttons/buynow",
	"buttons/buynow_highlight",
	"buttons/buynow_highlight"
};

MapTrialPlayGraphics = 
{
	"buttons/trialplay",
	"buttons/trialplay_highlight",
	"buttons/trialplay_highlight"
};

MapTrialPlayStyle = 
{
	parent=DefaultStyle,
	font=StandardButtonFont,
	type = kPush,
	xoffset = 0,
	yoffset = 0,
	flags = kHAlignCenter + kVAlignCenter,
	tx = 15,
	tw = kMax - 15,
};

MapTrialPlayJustBuyStyle = 
{
	parent=MapTrialPlayStyle,
	graphics=MapForSaleJustBuyGraphics,
	ty = 30,
	th = 45
};

MapTrialPlayBuyStyle =
{
	parent=MapTrialPlayStyle,
	graphics=MapForSaleGraphics,
	ty = 30,
	th = 45
};

MapTrialPlayTryStyle = 
{
	parent=MapTrialPlayStyle,
	graphics=MapTrialPlayGraphics,
	ty = 0,
	th = 30
};



function MakeComingSoonButton(xCoord,yCoord)
			

	return Group {
		SetStyle(MapForSaleStyle);
		Button
		{
			x = xCoord,
			y = yCoord,
			label = "comingsoon",
			command = 
				function()
					DisplayDialog{
						'scripts/ok.lua', 
						body ='comingsoonpopup',
						title = ''
					};
				end

		};

	};
end

function MakeRestaurantRollover(xCoord,yCoord,restaurant,labelVal)
			
	labelStr = restaurant..'_name';
	if (labelVal ~= nil) then
		labelStr = labelVal;
	end
	if (RestaurantExists(restaurant)) then
		return Group {
			Bitmap
			{
				name = restaurant..'_rollover',
				x = xCoord, y = yCoord,
				image = 'map/restaurant_rollover',
				Text
				{	
					x = 0, y = 0,
					w = kMax, h = kMax,
					label = labelStr,
					font = RestaurantRolloverFont,
					flags = kHAlignCenter + kVAlignCenter
				};
				
			};
		};
	else
		return Group {};
	end
end

function MakeDinertownRollover(xCoord, yCoord, label)
	return Group {
		Bitmap
		{
			name = label..'_rollover',
			x = xCoord, y = yCoord,
			image = 'map/restaurant_rollover',
			Text
			{	
				x = 0, y = 0,
				w = kMax, h = kMax,
				label = label,
				font = RestaurantRolloverFont,
				flags = kHAlignCenter + kVAlignCenter
			};
			
		};
	};
end

kButtonX = 35;
kButtonY = 9;
kButtonDeltaX = 50;


kButtonWindowHeight = -100;

if (BeatAnyRestaurantOnExpert() and GetCurrentGameMode() == 0) then
	kButtonWindowHeight = -145;
end
	
kLevelNumOffsetX = 0;
function LevelMarker(n)
	return Group {

			
		Button
		{
			name = 'levelbutton_'..n,
			x = kButtonX + (kButtonDeltaX*(n-1)), y = kButtonY,
			graphics=LevelButtonGraphics,
			type=kRadio,
			font = LevelNumFont,
			label = 'level'..n,
			tx= kLevelNumOffsetX,
			yoffset = 0,
			xoffset = 0,
			flags = kHAlignCenter + kVAlignCenter
		},
		
		Button
		{
			name = 'expertbutton_'..n,
			x = kButtonX + (kButtonDeltaX*(n-1)), y = kButtonY,
			graphics=ExpertButtonGraphics,
			type=kRadio,
			font = LevelNumFont,
			label = 'level'..n,
			tx= kLevelNumOffsetX,
			tw = kMax - 3,
			yoffset = 0,
			xoffset = 0,
			flags = kHAlignCenter + kVAlignCenter
		},
		
		Bitmap
		{
			name = 'lockedbutton_'..n,
			x = kButtonX + (kButtonDeltaX*(n-1)), y = kButtonY,
			image = "map/locked",
		
			Text
			{
				font = LevelNumFont,
				label = 'level'..n,
				x= kLevelNumOffsetX, y = 0,
				w=kMax, h=kMax,
				flags=kHAlignCenter+kVAlignCenter,
			},
		},
	}
end

function LevelMarkers()
	t= {}
	for i = 1,10 do
		table.insert(t,LevelMarker(i))
	end
	return Group(t)
end


MakeDialog
{
	Bitmap
	{
		name="backgroundimage",
		x = 0, y = 0, w = 800, h = 600,
		
		ChooseRestaurant
		{ 
			x=0,
			y=0,
			w=800,
			h=600,
			buttonX = 200,
			buttonY = 140,
			buttonDeltaX = 50,
			buttonDeltaY = 0,
			name="chooserestaurantwin",
			fit=false,
				
			SetStyle(SolidButtonStyle);
			

			
			
			
			MovingWindow
			{
				name="backpanel",
				x=0,y=400,
				w=0,h=kMax,
				dirX = -20,
				dirY = 0,
				startoff = 1,
				offDelay=100,
				
				Bitmap
				{
					x = 0,
					y = -90,
					image = "map/mapui_backpanel",
					
					Text
					{
						font = BestScoreFont,
						name="restaurantname",
						label="",
						x=220,
						y=7,
						w=kMax-100,
						h=kMax,
						flags = kHAlignLeft + kVAlignTop,
						padding = 0
					},
					
					Text
					{
						font = BestScoreFont,
						name="bestscore",
						label="bestscore",
						x=220,
						y=7,
						w=kMax-110,
						h=kMax,
						flags = kHAlignRight + kVAlignTop,
						padding = 0
					},
					
				},
				
				
			};
			FadingWindow
			{
				name="fadepanel",
				x = 0, y = 400;
				w = 300, h = kMax;
				lengthon = 1000,
				lengthoff = 100,
				startoff = 1

			};
			

			
			MovingWindow
			{
				name="buttonpanel",
				x=0,y=400,
				w=kMax,h=kMax,
				dirX = 0,
				dirY = 10,
				startoff = 1,
				onDelay = 250,
				
				Text
				{
					x = 0,
					y = -45,
					w = kMax-155,
					h = 50,
					font = SelectRestaurantFont,
					flags = kHAlignRight + kVAlignTop,
					label = 'selectarestaurant',
					name = 'selectarestaurant'
				};
					
				Bitmap
				{
					x = -152,
					y = kButtonWindowHeight,
					image = "map/mapui_buttonpanel",
					
					Bitmap
					{
						x=50,
						y=15,
						image="map/map_btn_playd",
						name="playdisabled",
						Text
						{
							label="play",
							x=0,y=0,w=kMax,h=kMax,
							flags = kVAlignCenter + kHAlignCenter
						};
					},
					Button
					{
						x=50,
						y=15,
						name="play",
						label="play",
						graphics={"map/map_btn_play", "map/map_btn_playb", "map/map_btn_playc"},
						command=
							function()
								if (SetupGame()) then
									restaurantName = GetCurrentRestaurantName();
									comicName = GetRestaurantFolder(restaurantName).."/comics/intro.swf";
									incrementedComicName = GetStrSetting("incrementrestaurant_mapscreenmovie", "");
									DebugOut("GetCurrentGameMode() == " .. tostring(GetCurrentGameMode()) .. ", GetCurrentLevel()=" .. tostring(GetCurrentLevel()) .. " incrementedComicName =" .. incrementedComicName);
									playMovie = GetCurrentGameMode() == 0 and GetCurrentLevel() == 0 and incrementedComicName ~= comicName;
									StartGame(playMovie);									
								end
							end
					},
					
					Button
					{
						x=50,
						y=60,
						name="back",
						label="mainmenu",
						graphics=PlayButtonGraphics,
						command=
							function()
								PopModal("scripts/chooserestaurant.lua");
							end
					},
					
					Button
					{
						x=50,
						y=105,
						graphics=PlayButtonGraphics,
						name="lockedlevels",
						label="lockedlevels",
						command=
							function()
								if (IsFirstPeek()) then
									DisplayDialog{
										'scripts/ok.lua', 
										body ='notinfirstpeek',
										title = ''
									};
								else
									DoModal("scripts/lockedlevels.lua");
								end
							end
					},
					
				},
			};
			
			MovingWindow
			{
				name="markerpanel",
				x=0,y=400,
				w=700,h=kMax,
				dirX = 30,
				dirY = 0,
				startoff = 1,
				onDelay = 300,
				
				Bitmap
				{
					x = 150,
					y = -65,
					image = "map/mapui_markerpanel",
					
					BeginGroup();
					LevelMarkers();
					
				},
			};
			
			
			
			SetStyle(DefaultStyle);

		};
		
		
	},
	
	FadingWindow
	{
		name="mapfadepanel",
		x = 0, y = 0;
		w = kMax, h = kMax;
		lengthon = 500,
		lengthoff = 500,
		startoff = 1,
		drawblack = true
	};
	
	
};

mappage = GetSessionSetting("chooserestaurant_mapsetting");
if (mappage ~= "") then
	SwitchMapPage(mappage);
end

SetupCurrentMapPage();
PlayMainMenuMusic();

